#ifndef _BINDHELP
#define _BINDHELP

typedef void *PWideString;
typedef void *PAnsiString;
typedef char *PAnsiChar;
typedef unsigned short *PWideChar;

// AnsiString routines
typedef void (*CopyCharsToPAnsiString)(const char *chars, PAnsiString pas);
typedef PAnsiChar (*CharsOfPAnsiString)(PAnsiString pas);
typedef void (*InitializePAnsiString)(PAnsiString &ps);
typedef void (*FinalizePAnsiString)(PAnsiString &ps);

extern CopyCharsToPAnsiString copyCharsToPAnsiString;
extern CharsOfPAnsiString charsOfPAnsiString;
extern InitializePAnsiString initPAnsiString;
extern FinalizePAnsiString finalPAnsiString;

inline void copyQCStringToPAnsiString(const QCString &qcs, PAnsiString pas)
{
  copyCharsToPAnsiString((const char *)qcs, pas);
}

inline void copyPAnsiStringToQCString(const PAnsiString pas, QCString &qcs)
{
  qcs = (const char *)CharsOfPAnsiString(pas);
}

inline void initializePAnsiString(PAnsiString &pas)
{
  initPAnsiString(pas);
}

inline void finalizePAnsiString(PAnsiString &pas)
{
  finalPAnsiString(pas);
}

C_EXPORT void initPAnsiStrings(CopyCharsToPAnsiString ctps,
  CharsOfPAnsiString cops, InitializePAnsiString ip, FinalizePAnsiString fp);

// WideString routines
typedef void (*CopyUnicodeToPWideString)(const QChar *unicode, PWideString ps, int len);
typedef PWideChar (*UnicodeOfPWideString)(PWideString ps);
typedef int (*LengthOfPWideString)(PWideString ps);
typedef void (*InitializePWideString)(PWideString &ps);
typedef void (*FinalizePWideString)(PWideString &ps);

extern CopyUnicodeToPWideString copyUnicodeToPWideString;
extern UnicodeOfPWideString unicodeOfPWideString;
extern LengthOfPWideString lengthOfPWideString;
extern InitializePWideString initPWideString;
extern FinalizePWideString finalPWideString;

inline void copyQStringToPWideString(const QString &qs, PWideString ps)
{
  copyUnicodeToPWideString(qs.unicode(), ps, qs.length());
}

inline void copyPWideStringToQString(PWideString ps, QString &qs)
{
  qs.setUnicodeCodes((ushort *)unicodeOfPWideString(ps),
    lengthOfPWideString(ps));
}

inline void initializePWideString(PAnsiString &pws)
{
  initPWideString(pws);
}

inline void finalizePWideString(PWideString &pws)
{
  finalPWideString(pws);
}

C_EXPORT void initPWideStrings(CopyUnicodeToPWideString cutps,
  UnicodeOfPWideString uops, LengthOfPWideString lops,
  InitializePWideString ip, FinalizePWideString fp);

// QPointArray helpers
typedef void *PPointArray;
typedef void *(*GetPointsPtr)(PPointArray pa);
typedef int (*GetPointsLength)(PPointArray pa);
typedef void (*SetPointsLength)(PPointArray pa, int len);
extern GetPointsPtr getPointsPtr;
extern GetPointsLength getPointsLength;
extern SetPointsLength setPointsLength;

inline void copyQPointArrayToPPointArray(const QPointArray &qp, PPointArray pa)
{
  int len = qp.size();
  QCOORD *points;
  setPointsLength(pa, len);
  points = (QCOORD *)getPointsPtr(pa);
  for (int i = 0; i < len; i++)
    qp.point(i, &points[i * 2], &points[i * 2 + 1]);
}

inline void copyPPointArrayToQPointArray(PPointArray pa, QPointArray &qp)
{
  int len = getPointsLength(pa);
  qp.resize(len);
  qp.setPoints(len, (QCOORD *)getPointsPtr(pa));
}

C_EXPORT void initializePPointArray(GetPointsPtr gpp, GetPointsLength gpl,
  SetPointsLength spl);

// QRect helpers
typedef void *PRect;

inline void copyQRectToPRect(const QRect &qr, PRect pr)
{
  *(QRect *)pr = qr;
  ((QRect *)pr)->rRight()++;
  ((QRect *)pr)->rBottom()++;
}

inline void copyPRectToQRect(PRect pr, QRect &qr)
{
  qr = *(QRect *)pr;
  qr.rRight()--;
  qr.rBottom()--;
}

inline void copyPWideCharToQChar(PWideChar pw, QChar &qc)
{
  //byte swap for Qt 2. In Qt 3, QChar has the correct byte order.
  qc = QChar( ((unsigned char *)pw)[0], ((unsigned char *)pw)[1] );
}

inline void copyQCharToPWideChar(QChar qc, PWideChar pw)
{
  *pw = qc.unicode();   
}

// QValueList<int> helpers
typedef void *PIntArray;
typedef void *(*GetIntsPtr)(PIntArray pi);
typedef int (*GetIntsLength)(PIntArray pi);
typedef void (*SetIntsLength)(PIntArray pi, int len);
extern GetIntsPtr getIntsPtr;
extern GetIntsLength getIntsLength;
extern SetIntsLength setIntsLength;

inline void copyQIntsToPInts(const QValueList<int> &qi, PIntArray pi)
{
  int len = qi.count();
  int *ints;
  setIntsLength(pi, len);
  ints = (int *)getIntsPtr(pi);
  for (int i = 0; i < len; i++)
    ints[i] = qi[i];
}

inline void copyPIntsToQInts(PIntArray pi, QValueList<int> &qi)
{
  int len = getIntsLength(pi);
  int *ints = (int *)getIntsPtr(pi);
  qi.clear();
  for (int i = 0; i < len; i++)
    qi.append(ints[i]);
}

C_EXPORT void initializePIntArray(GetIntsPtr gip, GetIntsLength gil,
  SetIntsLength sil);

#endif
